#version 140
#extension GL_EXT_gpu_shader4 : enable
// SubzeroMod01.fsh by  njo

//https://www.shadertoy.com/view/MtySzG
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels


#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize


#define iMouse AUTO_MOUSE
#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
#define RIGID_SCROLL
// alternatively use static mouse definition
//#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define SCALE (200.0)
#define SCALE_INV (1.0/SCALE)
#define MAX_HEIGHT (SCALE)
#define WATER_BASE (MAX_HEIGHT * 0.5)
#define SUN_DIR (normalize(vec3(1.5, 0.8, -1.0)))
#define SUN_COLOR (vec3(1.0, 1.0, 0.9))
#define VIEW_DIR (vec3(0.0, 0.0, -1.0))
#define MAX_DRAW (10.0 * SCALE)
#define PRECISION (0.01 * SCALE)
#define WATER 1
#define LAND 2
#define SKY 3

float noise(vec2 p) {
    //return textureLod(iChannel0, p, 0.0).x;
    return texture2D(iChannel0, p, 0.0).x;
}

float f(vec2 p) {
   	vec2 v = p * 0.0108 * SCALE_INV;
    float sum = 0.0;
    float div = 0.0;
    for (int i = 1; i < 33; i = i * 2) {
        sum += (1.0 / float(i)) * noise(v * float(i));
        div += 1.0 / float(i);
    }
    
	float height = sum / div;
    height = pow(height, 1.2) * 1.1;
    return height * SCALE;
}

vec3 get_normal(vec3 p) {
    float eps = 0.009 * SCALE;
    vec3 n = vec3( f(vec2(p.x-eps,p.z)) - f(vec2(p.x+eps,p.z)),
                         2.0*eps,
                         f(vec2(p.x,p.z-eps)) - f(vec2(p.x,p.z+eps)) );
    return normalize(n);
}

vec3 fog(vec3 col, float dist) {
    //http://iquilezles.org/www/articles/fog/fog.htm
    float fog_amount = 1.0 - exp(-dist * SCALE_INV * 0.2);
    vec3 fog_col = vec3(1.0, 1.0, 1.0);
    return mix(col, fog_col, fog_amount);  
}

vec3 terrain_color(vec3 p, vec3 cam_pos, vec3 n) {
    return vec3(0.55, 0.59 ,0.64) * 1.7;
    return vec3(1.0);
    return mix(vec3(1.0), vec3(0.0, 0.0, 0.1), clamp(dot(n, vec3(0.0, -1.0, 0.0)), 0.0, 14.0) );
}

vec3 sky_color(vec3 dir) {
 	return mix(vec3(0.3, 0.6, 0.8), SUN_COLOR, pow(max(dot(dir, SUN_DIR), 0.0), 10.0));
}

float refl_ray(vec3 origin, vec3 dir) {
    for (float t = 0.0; t < MAX_HEIGHT; t += 1.0) {
   		vec3 p = origin + dir * t;
        if (p.y - f(p.xz) < PRECISION) {
            return t;
        }
    }
    return MAX_HEIGHT;
}

float refr_ray(vec3 origin, vec3 dir) {
    float t = 0.0;
    for (int i = 0; i < 64; i++) {
        vec3 p = t * dir + origin;
        float h = p.y - f(p.xz);
        if (h < 0.01) {
            return t;
        }
        t += 0.6 * h;
    }
    return t;
}
float shadow(vec3 ro) {
    //http://www.iquilezles.org/www/articles/rmshadows/rmshadows.htm
    float res = 1.0;
    float t = 2.0;
    float k = 16.0;
	for(int i = 0; i < 64; i++ ){
	    vec3 p = ro + t * SUN_DIR;
        float h = p.y - f(p.xz);
        float c = k * h / t;

		res = min(res, c);
		t += 0.25 * h;
        if(res < 0.001 || p.y > MAX_HEIGHT) {
            break;
        }
	}
	return clamp( res, 0.0, 1.0 );
}
    
vec3 water_color(vec3 water_pos, vec3 cam_pos, vec3 dir, vec3 n) {
    vec3 view = normalize(water_pos - cam_pos);
    vec3 deep_col = vec3(0.0, 0.0, 0.08);
    vec3 shal_col = vec3(0.0, 0.23, 0.3);
    
    vec3 col = mix(deep_col, shal_col, 1.0 - max(dot(-view, n), 0.0));

    vec3 rd = normalize(reflect(dir, n));
    
    float t = refl_ray(water_pos, rd);
    vec3 ter_pos = t * rd + water_pos;
    vec3 refl_col = t >= MAX_HEIGHT ? sky_color(rd) : terrain_color(ter_pos, cam_pos, get_normal(ter_pos));
    
    rd = normalize(refract(dir, n, 3.0/4.0)); 
    t = refr_ray(water_pos, rd);
    ter_pos = t * rd + water_pos;
    vec3 refr_col = terrain_color(ter_pos, cam_pos, get_normal(ter_pos));
    
    refr_col = mix(refr_col, vec3(0.0, 0.05, 0.0), clamp(length(ter_pos.y - water_pos.y)*0.08, 0.0, 1.0));
    col = col + mix(refl_col, refr_col, clamp(pow(dot(-view, n), 1.0), 0.0, 1.0));
    return col;
}
float wnoise(vec2 p) {
    //http://www.decarpentier.nl/scape-procedural-basics
    //return 1.0 - abs(textureLod(iChannel0, p, 0.0).x * 2.0 - 1.0);
    return 1.0 - abs(texture2D(iChannel0, p, 0.0).x * 2.0 - 1.0);
}

float water_fbm(vec2 p, float time) {
   	vec2 v = p * 0.022 * SCALE_INV;
    float sum = 0.0;
    float div = 0.0;
    for (int i = 1; i < 9; i = i * 2) {
        sum += (1.0 / float(i)) * wnoise(v * float(i) + time * 0.0003);
        div += 1.0 / float(i);
    }
    
	float height = sum / div;
    return pow(height , 4.0) * 8.0;
}

float water_level(vec2 p, float time) {
    return water_fbm(p, time) + WATER_BASE;
}


vec3 get_wn(vec3 p, float time) {
    float eps = 0.01 * SCALE;
    vec3 n = vec3(water_level(vec2(p.x-eps,p.z), time) - water_level(vec2(p.x+eps,p.z), time),
                  2.0*eps,
                  water_level(vec2(p.x,p.z-eps), time) - water_level(vec2(p.x,p.z+eps), time));
    return normalize(n);
}
vec3 render(vec3 ray_origin, vec3 direction) {
    float time = iTime * 5.0; 
	float t = 0.0;

    float water_lvl;
    vec3 col;
    vec3 p;
    int type = SKY;
    vec3 n;
    for (int i = 0; i < 256; i++) {
        p = t * direction + ray_origin;
        water_lvl = water_level(p.xz, time);
        float tlvl = f(p.xz);
        float s = max(tlvl, water_lvl);
        if ((p.y > MAX_HEIGHT && direction.y > 0.0) || t > MAX_DRAW) {
            break;
        }       
        if (p.y - water_lvl < PRECISION) {
            type = WATER;
            break;
        }
        if (p.y - tlvl < PRECISION) {
            type = LAND; 
            break;
        }
        t += 0.2 * (p.y - s);    
    }
    if (type == WATER) {
        vec3 wpos = vec3(p.x, water_lvl, p.z);
        n = get_wn(wpos, time);
        col = water_color(wpos, ray_origin, direction, n);
        
    } else if (type == LAND) {
        n = get_normal(p);
        col = terrain_color(p, ray_origin, n);
    } else {
        col = sky_color(direction);
    }
    if (type != SKY) {
        //http://www.iquilezles.org/www/articles/outdoorslighting/outdoorslighting.htm
        float sha = shadow(p);
        float sun = clamp(dot(n, SUN_DIR), 0.0, 1.0);
        float sky = clamp(0.5 + 0.5 * n.y, 0.0, 1.0);
        float ind = clamp(dot(n, normalize(SUN_DIR * vec3(-1.0, 0.0, -1.0))), 0.0, 1.0);
        vec3 lin = sun * vec3(1.3, 1.3, 1.3) * sha * 0.8;
        lin += sky * vec3(0.3, 0.3, 0.3);
        lin += ind * vec3 (0.3, 0.3, 0.3);
        col = lin * col;

    }
            
    return fog(col, length(p - ray_origin));
}
void main (void)                    
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    float z = -iTime * 20.0;
    vec2 forward_pos = vec2(1000.0, z - 10.0);
    vec2 prev_pos = vec2(1000.0, z + 10.0);
    vec2 cur_pos = vec2(1000.0, z);
    
    float height = (max(f(forward_pos),WATER_BASE ) + max(f(prev_pos), WATER_BASE)) * 0.5;
    vec3 camera_pos = vec3(cur_pos.x, height + 50.0, cur_pos.y);
    vec3 camera_forward = normalize(vec3(0.0, -0.5, -1.0));
    vec3 camera_up = normalize(vec3(0.0, 1.0, -0.5));
    vec3 camera_right = vec3(1.0, 0.0, 0.0);
 
    // Pixel pos in [-1 + 1/res, 1 - 1/res]
    vec2 pixel_pos = (2.0*gl_FragCoord.xy - iResolution.xy)/iResolution.xy;
   	// https://www.scratchapixel.com/lessons/3d-basic-rendering/ray-tracing-generating-camera-rays/generating-camera-rays
    pixel_pos.x *= iResolution.x / iResolution.y; // Aspect ratio

    vec3 ray_dir = normalize(normalize(camera_forward) + camera_up * pixel_pos.y + camera_right * pixel_pos.x);    

    vec3 ray_origin = camera_pos;

  	vec3 col = render(ray_origin, ray_dir);  
    gl_FragColor = vec4(col, 1.0);

}